# 브라우저(Browser)와 렌더링(Rendering)

## 브라우저(Browser)

MDN Web Docs에서 정의하는 브라우저는 다음과 같다.

> A Web browser or browser is a program that retrieves and displays pages from the Web, and lets users access further pages through hyperlinks. A browser is the most familiar type of user agent. - [mdn web docs](https://developer.mozilla.org/en-US/docs/Glossary/Browser)

웹 브라우저(브라우저)는 웹에서 페이지를 검색 및 표시하고, 사용자가 하이퍼링크를 통해 추가 페이지에 접근할 수 있도록 하는 프로그램이다. 브라우저는 가장 친숙한 사용자 에이전트\* 유형이다.

_\* 에이전트 : 사용자 대신 일을 수행하는 소프트웨어_

다르게 풀이하면 **서버(Server)로부터 자원(Resource)을 받아오고 해석하여 사용자(Client)에게 보여주는 소프트웨어** 이다. Google Chrome, Microsoft Edge, Naver Whale, Mozilla Firefox, Apple Safari 등이 브라우저에 해당한다.

브라우저가 HTML 파일을 해석하고 표시하는 방식은 HTML 및 CSS 명세서에 지정되어 있고, 이는 웹 표준 조직인 **W3C(World Wide Web Consortium)** 에서 관리한다. 오늘날 대부분의 브라우저가 이 표준을 따른다.

<br/>

## 브라우저 상위 수준 구조

브라우저의 주요 구조는 다음과 같다.

![Figure : Browser components](https://web-dev.imgix.net/image/T4FyVKpzu4WKF1kBNvXepbi08t52/PgPX6ZMyKSwF6kB8zIhB.png?auto=format&w=500)  
_Figure : Browser components_

1. **사용자 인터페이스(User Interface, UI)** : 요청한 페이지가 표시되는 창을 제외한 브라우저 디스플레이의 모든 부분. 주소 표시줄, 버튼 등 사용자와 직접 맡닿는 모든 것을 의미한다.

2. **Browser engine** : UI와 렌더링 엔진을 마샬링(marshaling)한다. 마샬링은 한 객체의 메모리상 표현 방식을 저장 및 전송에 용이한 형태로 변환하는 것을 말한다. 따라서 UI와 렌더링 엔진 사이의 통신을 용이하게 해준다. _Rendering Engine과 혼용되어 설명되는 경우가 많은 것으로 보인다._

3. **Rendering engine** : 요청된 콘텐츠를 표시한다. 예를 들어 요청한 콘텐츠가 HTML인 경우 렌더링 엔진은 HTML과 CSS를 구문 분석(parse)하고 구문 분석된 콘텐츠를 화면에 표시한다. 브라우저마다 다른 렌더링 엔진을 사용한다.Firefox는 Gecko, Safari는 Webkit, Chrome은 Blink를 사용한다.

4. **Networking** : HTTP 요청과 같은 네트워크 요청을 하는 통신 파트이다. 올바른 연결 제한, 요청 형식 지정, 프록시 처리, 캐싱 등을 적용한다.

5. **UI Backend** : 운영 체제의 사용자 인터페이스 메서드를 사용하여 체크 박스, 입력창과 같은 기본 위젯을 그린다.

6. **Javascript Interpreter** : JavaScript 코드를 구문 분석하고 실행하는 데 사용됩니다.

7. **데이터 저장(Data Persistence)** : 데이터 저장 계층, 영속 계층이다. 쿠키와 같은 모든 종류의 데이터를 로컬에 저장한다. localStorage, IndexedDB, WebSQL 및 FileSystem과 같은 저장 메커니즘을 지원합니다.

<br/>

## 렌더링(Rendering)

렌더링은 요청한 자원(Resource)을 브라우저의 화면에 표시하는 과정을 말한다. 렌더링의 과정을 살펴본다. 자원은 일반적으로 PDF, Image 또는 기타 유형일 수 있지만 가장 일반적인 예로 CSS로 스타일링 된 HTML의 경우를 살펴본다.

먼저 사용자가 특정 문서를 요청하면 렌더링 엔진이 요청된 문서의 콘텐츠를 가져오기 시작한다. 이것은 브라우저의 네트워킹 계층을 통해 수행되며 일반적으로 8KB chunk로 문서의 내용을 수신한다. 그 후 아래의 렌더링 과정이 진행된다.

![Figure : Rendering engine basic flow](https://web-dev.imgix.net/image/T4FyVKpzu4WKF1kBNvXepbi08t52/bPlYx9xODQH4X1KuUNpc.png?auto=format&w=650)  
_Figure : Rendering engine basic flow_

1. 렌더링 엔진이 요청된 HTML을 외부 CSS 파일 및 스타일 요소를 포함하여 파싱한다. 파싱한 HTML 요소는 `DOM 노드`로 변환되어 `DOM 트리`를 형성한다.

2. 동시에 브라우저는 `렌더 트리(Render Tree)`도 생성한다. 렌더 트리는 스타일 정보 뿐만 아니라 요소가 표시되는 순서의 정의를 모두 포함하기 때문에 콘텐츠가 요구되는 순서대로 표시된다.

3. 렌더 트리가 `Layout` 프로세스를 거친다. 렌더 트리가 생성되어도 위치나 크기 값은 할당되지 않는다. 위치 등의 값을 계산하는 과정을 레이아웃 프로세스라고 한다. 이 과정에서 모든 노드에 좌표가 할당되어 정확한 위치에 나타난다.

4. 마지막 단계인 `Painting`은 화면을 그리는 것이다. 렌더 트리를 순회하고, UI 백엔드 레이어를 사용하여 화면의 각 노드를 그리는 렌더러의 paint() 메서드가 호출된다.

\* 더 나은 사용자 경험을 위해 렌더링 엔진은 모든 HTML 구문 분석이 되기를 기다리지 않고 렌더트리를 빌드하고 레이아웃 과정을 진행한다. 네트워크로부터 오는 콘텐츠들을 파싱하며 위 과정들이 점진적으로 진행된다.

<br/>

## Webkit의 렌더링과 추가 개념

위 과정은 브라우저 엔진의 렌더링 과정을 대략적으로 살펴본 것이다. 더 세부적인 도표는 아래와 같다. 브라우저마다 다른 렌더링 엔진을 사용하기 때문에 그 중에서 Webkit의 예를 가져왔다.

![Figure : WebKit main flow](https://web-dev.imgix.net/image/T4FyVKpzu4WKF1kBNvXepbi08t52/S9TJhnMX1cu1vrYuQRqM.png?auto=format&w=650)

_Figure : WebKit main flow_

<br/>

#### Parsing

Parsing(구문 분석)은 것은 일련의 문자열을 분해하여 사용할 수 있는 구조로 변환하는 것을 의미한다. 구문 분석의 결과는 일반적으로 구조를 나타내는 노드 트리이며 이를 `parse tree` 또는 `syntax tree`라고 한다.

#### DOM(Document Object Model)

위 설명들에서 언급되는 DOM은 문서 객체 모델이다. DOM은 문서 형태인 웹페이지를 nodes와 objects 형태로 표현하여 Javascript 등의 프로그래밍 언어가 접근할 수 있는 방법을 제공한다. 이를 통해 스크립트 또는 프로그래밍 언어들에서 웹페이지를 조작할 수 있게 된다.

#### Attachment

Attachment는 WebKit 렌더링 엔진에서 사용되는 용어로, 렌더 트리를 생성하기 위해 DOM 노드들을 스타일 정보와 결합하는 과정을 의미한다.

<br/>

---

## Reference

📄 https://web.dev/howbrowserswork/#Resources  
브라우저 동작 방법과 관련한 많은 글들이 이스라엘 개발자 [Tali Garsiel의 연구 결과](http://taligarsiel.com/Projects/howbrowserswork1.htm)를 토대로 작성되어있다. Tali Garsiel 가 수 년 동안 내부 소스코드를 분석하여 정리한 내용이 잘 정리된 위 글을 첨부한다. HTML, CSS Parser, Layout, Painting 등 더 자세한 내용들을 확인할 수 있다.  
📄 https://blog.cloudthat.com/an-ultimate-guide-browser-rendering-engine/  
📄 https://www.browserstack.com/guide/browser-rendering-engine  
📄 https://velog.io/@grinding_hannah/Web-%EB%B8%8C%EB%9D%BC%EC%9A%B0%EC%A0%80-%EC%9E%91%EB%8F%99-%EC%9B%90%EB%A6%AC
📄 https://developer.mozilla.org/ko/docs/Web/API/Document_Object_Model/Introduction
